# Python Connector for Snowflake #

Python Connector for Snowflake is a connectivity solution for accessing
the Snowflake data cloud from Python applications. It fully implements
the Python DB API 2.0 specification. The connector is distributed as a wheel
package for Windows and Windows Server.

## Using the connector ##

To retrieve data from a database:

Import the module.
```
import devart.snowflake
```

Connect to a database using the `connect()` module method and obtain a `connection` object.
```
my_connection = devart.snowflake.connect(
    Domain="your_instance;",
    UserId="your_username",
    Password="your_password",Database="your_database;"
)
```

Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```

Execute the SQL statement using the `execute()` cursor method.
```
my_cursor.execute("SELECT * FROM employees")
```

Retrieve the result set using one of the `fetch*()` cursor methods.
```
for row in my_cursor.fetchall(): 
    print(row)
```

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/snowflake/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/snowflake/activate-a-license.htm

## What's new ##

Python Connector for Snowflake 1.2

- Added support for Python 3.13
