# Python Connector for Snowflake #

Python Connector for Snowflake is a connectivity solution for accessing
the Snowflake data cloud from Python applications. It fully implements
the Python DB API 2.0 specification. The connector is distributed as a wheel
package for Windows and Windows Server.

## Connecting ##

To establish a connection to a Snowflake database, import the connector and
use the `connect()` method with your connection parameters.

### Import the connector ###

First, import the Snowflake connector module:

```
my_connection = snowflake.connect(
    Domain="your_instance;",    UserId="your_username",    Password="your_password",Database="your_database;"
)
```

### Establish a connection ###

Call the `connect()` method and obtain a `connection` object.

```
response = snowflake.signin()
my_connection = snowflake.connect(
    CompanyId=response["Company Id"],
    RefreshToken=response["Refresh Token"]
)
```

Replace the example values with your actual connection values.

## Querying data ##

Once connected, you can execute SQL queries to retrieve data from
your Snowflake database.

### Execute a query ###

Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```
Execute a SQL query using the `execute()` cursor method.
```
my_cursor.execute("SELECT * FROM employees")
```
Retrieve results using one of the `fetch*()` methods.
```
for row in my_cursor.fetchall(): 
    print(row)
```

### Parameterized queries ###

You can use parameterized queries to pass variable values to your SQL statements. This allows you to reuse the same query with different data and helps to prevent SQL injection attacks.

Pass parameters as a list or tuple to the `execute()` method:

```
for row in my_cursor.fetchall(): 
    print(row)
```

Each placeholder `?` in the query is replaced with a corresponding value from the parameter list.

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/snowflake/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/snowflake/activate-a-license.htm

## What's new ##

Python Connector for Snowflake 1.3

- Added support for Python 3.14
