# Python Connector for SQLite #

Python Connector for SQLite is a connectivity solution for accessing SQLite
databases from Python applications. It fully implements the Python DB API 2.0
specification. The connector is distributed as a wheel package for Windows,
macOS, and Linux.

Direct connection

The connector supports two SQLite library linking modes: static linking and
dynamic linking. Static linking enables a direct connection to SQLite, so you
don't have to deploy the SQLite libraries on user workstations. You can use
the built-in encryption capabilities in the Direct mode to protect your data
from unauthorized access?the statically linked library provides SQLite
database encryption without requiring you to purchase an encryption extension.

## Connecting ##

To establish a connection to an SQLite database, import the connector and use
the `connect()` method with your connection parameters.

### Import the connector ###

First, import the SQLite connector module:

```
import devart.sqlite
```

### Establish a connection ###

Connect to a database using the `connect()` module method and obtain a `connection` object.

You can connect in Direct mode or by using a dynamically linked SQLite client library.

#### Direct mode ####

In Direct mode, the connector works without requiring an external SQLite client library. Provide the path to your database file:

```
my_connection = sqlite.connect(
    Direct=True,
    Database="your_database"
)
```

Replace the example value with the path to your actual database file.

#### Dynamically linked SQLite client library ####

You can also connect using a dynamically linked SQLite client library. Provide the path to the client library file along with the database file:

```
my_connection = devart.sqlite.connect(
    Direct=False,
    Database="your_database",
    ClientLibrary="your_sqlite_lib"
)
```

Replace the example values with your actual database and client library paths.

## Querying data ##

Once connected to SQLite, you can execute SQL queries to retrieve data from
your SQLite database.

### Execute a query ###

Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```
Execute a SQL query using the `execute()` cursor method.
```
my_cursor.execute("SELECT * FROM employees")
```
Retrieve results using one of the `fetch*()` methods.
```
for row in my_cursor.fetchall():
    print(row)
```

### Parameterized queries ###

You can use parameterized queries to pass variable values to your SQL statements. This allows you to reuse the same query with different data and helps to prevent SQL injection attacks.

Pass parameters as a list or tuple to the 

`execute()`

 method:

```
query = "SELECT Id, Name FROM Contact WHERE Name = ? AND Email = ?"
params = ["Jordan Sanders", "jordansanders@example.com"]
my_cursor.execute(query, params)
results = my_cursor.fetchall()
for row in results:
    print(row)
```

Each placeholder `?` in the query is replaced with a corresponding value from the parameter list.

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/sqlite/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/sqlite/activate-a-license.htm

## What's new ##

Python Connector for SQLite 1.3

- Added support for Python 3.14
