# Python Connector for xBase #

Python Connector for xBase is a connectivity solution for accessing FoxPro,
Visual FoxPro, dBase, and other databases in DBF file formats from Python
applications. It fully implements the Python DB API 2.0 specification.
The connector is distributed as a wheel package for Windows, macOS, and Linux.

Direct connection

The connector enables you to establish a direct connection to Visual FoxPro,
dBase, and other xBase databases eliminating the need for the client library.
A direct connection increases the speed of data transmission between a Python
application and an xBase database and simplifies the deployment.

Local indexing

The connector offers an internal data indexing mechanism that is way more
efficient than native DBF indexes for complex queries.

Retrieval of corrupted data

## Connecting ##

To establish a connection to an xBase database, import the connector and use
the `connect()` method with your connection parameters.

### Import the connector ###

First, import the xBase connector module:

```
import devart.xbase as xbase
```

### Establish a connection ###

Call the `connect()` method and obtain a `connection` object.

```
my_connection = xbase.connect(
    Database="path_to_db"
)
```

Replace `Database` with the actual path to your xBase database file.

## Querying data ##

Once connected, you can execute SQL queries to retrieve data from your xBase
files.

### Execute a query ###

Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```
Execute a SQL query using the `execute()` cursor method.
```
my_cursor.execute("SELECT * FROM employees")
```
Retrieve results using one of the `fetch*()` methods.
```
for row in my_cursor.fetchall(): 
    print(row)
```

### Parameterized queries ###

You can use parameterized queries to pass variable values to your SQL statements. This allows you to reuse the same query with different data and helps to prevent SQL injection attacks.

Pass parameters as a list or tuple to the 

`execute()`

 method:

```
query = "SELECT Id, Name FROM Contact WHERE Name = ? AND Email = ?"
params = ["Jordan Sanders", "jordansanders@example.com"]
my_cursor.execute(query, params)
results = my_cursor.fetchall()
for row in results:
    print(row)
```

Each placeholder `?` in the query is replaced with a corresponding value from the parameter list.

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/xbase/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/xbase/activate-a-license.htm

## What's new ##

Python Connector for xBase 1.3

- Added support for Python 3.14
- Improved support of the HiPerSix database format
