# Python Connector for Zoho CRM #

Python Connector for Zoho CRM is a connectivity solution for accessing Zoho
CRM from Python applications to read and update data. It fully implements
the Python DB API 2.0 specification. The connector is distributed as a wheel
package for Windows and Windows Server.

Standard SQL syntax

The connector fully supports the ANSI SQL standard and lets you execute SQL
statements against your Zoho CRM data just like you would normally work with
relational databases. Simple queries are directly converted to Zoho CRM API
calls and executed on the Zoho CRM side.

## Connecting ##

To establish a connection to a Zoho CRM database, import the connector and use
the `connect()` method with your connection parameters.

### Import the connector ###

First, import the Zoho CRM connector module:

```
import devart.zohocrm as zohocrm
```

### Establish a connection ###

For Zoho CRM, authentication is performed using OAuth 2.0. First, obtain a refresh token with the `signin()` method, then use it to connect:

```
response = zohocrm.signin(Domain="your_zoho_domain")
my_connection = zohocrm.connect(
    Domain="your_zoho_domain",
    RefreshToken=response["Refresh Token"]
)
```

Replace the example values with your actual connection details, such as your Zoho domain and refresh token.

## Querying data ##

Once connected, you can execute SQL queries to retrieve data from your Zoho
CRM account.

### Execute a query ###

Create a `cursor` object using the `cursor()` connection method.
```
my_cursor = my_connection.cursor()
```
Execute a SQL query using the `execute()` cursor method.
```
my_cursor.execute("SELECT * FROM employees")
```
Retrieve results using one of the `fetch*()` methods.
```
for row in my_cursor.fetchall(): 
    print(row)
```

### Parameterized queries ###

You can use parameterized queries to pass variable values to your SQL statements. This allows you to reuse the same query with different data and helps to prevent SQL injection attacks.

Pass parameters as a list or tuple to the 

`execute()`

 method:

```
query = "SELECT Id, Name FROM Contact WHERE Name = ? AND Email = ?"
params = ["Jordan Sanders", "jordansanders@example.com"]
my_cursor.execute(query, params)
results = my_cursor.fetchall()
for row in results:
    print(row)
```

Each placeholder `?` in the query is replaced with a corresponding value from the parameter list.

## Ordering and activating the license ##

You can purchase a license for the connector on the ordering page:             
https://www.devart.com/python/zohocrm/ordering.html

To activate the license, follow the instructions in the documentation:             
https://docs.devart.com/python/zohocrm/activate-a-license.htm

## What's new ##

Python Connector for Zoho CRM 1.3

- Added support for Python 3.14
- Added support for the Saudi Arabia data center
