CREATE TABLE SDAC_Long_char (
  Code INT IDENTITY (1, 1) PRIMARY KEY,
  Title VARCHAR(30),
  Value VARCHAR(5000)
);

CREATE TABLE SDAC_Pictures (
  UID int IDENTITY (1, 1) PRIMARY KEY NOT NULL,
  Name VARCHAR(50),
  Picture IMAGE
);

CREATE TABLE Loaded1 (
  uid INT IDENTITY (1, 1) NOT NULL PRIMARY KEY,
  Field1 VARCHAR(20),
  Field2 VARCHAR(20),
  Field3 VARCHAR(20)
);

CREATE TABLE Loaded2 (
  uid INT IDENTITY (1, 1) NOT NULL PRIMARY KEY,
  Field1 VARCHAR(20),
  Field2 VARCHAR(20),
  Field3 VARCHAR(20)
);

CREATE TABLE ThreadTable (
  ID INT,
  NAME VARCHAR(30)
);

CREATE TABLE SDAC_Text (
  UID INT IDENTITY PRIMARY KEY,
  [Name] NVARCHAR(50),
  TextField NTEXT
);

CREATE TABLE Sdac_Loaded (
  Code INT,
  Num INT,
  Num1 FLOAT,
  Str VARCHAR(50),
  Dat DATETIME
);

CREATE TABLE CRGRID_TEST(
  Id int PRIMARY KEY,
  Name VARCHAR(10),
  Country VARCHAR(30),
  City VARCHAR(30),
  Street VARCHAR(30),
  BirthDate DATETIME,
  Job VARCHAR(9),
  Hiredate DATETIME,
  Sal NUMERIC(7, 2),
  Remarks TEXT
);

INSERT INTO CRGRID_TEST 
  (Id, Name, Country, City, Street, BirthDate, Job, HireDate, Sal)
VALUES 
  (5001, 'SMITH', 'ENGLAND', 'LONDON', 'BOND st.', '12-OCT-63', 'CLERK','17-DEC-80', 800);
INSERT INTO CRGRID_TEST
  (Id, Name, Country, City, Street, BirthDate, Job, HireDate, Sal)
VALUES 
  (5002, 'ALLEN', 'ENGLAND', 'LONDON', 'BAKER st.', '04-MAR-61', 'SALESMAN','20-FEB-81', 1600);
INSERT INTO CRGRID_TEST 
  (Id, Name, Country, City, Street, BirthDate, Job, HireDate, Sal)
VALUES 
  (5003, 'MARTIN', 'FRANCE', 'LION', 'WEAVER st.', '23-JAN-57', 'MANAGER','02-APR-81', 2900);
  
  CREATE TABLE DEPT (
  DEPTNO INT PRIMARY KEY,
  DNAME VARCHAR(14),
  LOC VARCHAR(13)
);
INSERT INTO DEPT VALUES (10,'ACCOUNTING','NEW YORK');
INSERT INTO DEPT VALUES (20,'RESEARCH','DALLAS');
INSERT INTO DEPT VALUES (30,'SALES','CHICAGO');
INSERT INTO DEPT VALUES (40,'OPERATIONS','BOSTON');

CREATE TABLE emp (
  EMPNO int IDENTITY(1,1) NOT NULL PRIMARY KEY,
  ENAME varchar(10) default NULL,
  JOB varchar(9) default NULL,
  MGR int default NULL,
  HIREDATE datetime default NULL,
  SAL float default NULL,
  COMM float default NULL,
  DEPTNO int default NULL
  );
INSERT INTO emp VALUES ('SMITH', 'CLERK', 7902, '1980-12-17 00:00:00', 800, NULL, 20);
INSERT INTO emp VALUES ('ALLEN', 'SALESMAN', 7698, '1981-02-20 00:00:00', 1600, 300, 30);
INSERT INTO emp VALUES ('WARD', 'SALESMAN', 7698, '1981-02-22 00:00:00', 1250, 500, 30);
INSERT INTO emp VALUES ('JONES', 'MANAGER', 7839, '1981-04-02 00:00:00', 2975, NULL, 20);
INSERT INTO emp VALUES ('MARTIN', 'SALESMAN', 7698, '1981-09-28 00:00:00', 1250, 1400, 30);
INSERT INTO emp VALUES ('BLAKE', 'MANAGER', 7839, '1981-05-01 00:00:00', 2850, NULL, 30);
INSERT INTO emp VALUES ('CLARK', 'MANAGER', 7839, '1981-06-09 00:00:00', 2450, NULL, 10);
INSERT INTO emp VALUES ('SCOTT', 'ANALYST', 7566, '1987-07-13 00:00:00', 3000, NULL, 20);
INSERT INTO emp VALUES ('KING', 'PRESIDENT', NULL, '1981-11-17 00:00:00', 5000, NULL, 10);
INSERT INTO emp VALUES ('TURNER', 'SALESMAN', 7698, '1981-09-08 00:00:00', 1500, 0, 30);
INSERT INTO emp VALUES ('ADAMS', 'CLERK', 7788, '1987-07-13 00:00:00', 1100, NULL, 20);
INSERT INTO emp VALUES ('JAMES', 'CLERK', 7698, '1981-12-03 00:00:00', 950, NULL, 30);
INSERT INTO emp VALUES ('FORD', 'ANALYST', 7566, '1981-12-03 00:00:00', 3000, NULL, 20);
INSERT INTO emp VALUES ('MILLER', 'CLERK', 7782, '1982-01-23 00:00:00', 1300, NULL, 10);

GO

CREATE PROCEDURE SDAC_InsertEmp  
	@ENAME	nvarchar(20),
	@JOB	nvarchar(10)
AS
	INSERT INTO 
		EMP (ENAME, JOB) 
	VALUES
		(@ENAME, @JOB) 
	RETURN @@Identity;

GO

CREATE PROCEDURE SDAC_UpdateEmp  
	@EMPNO	int,
	@ENAME	nvarchar(20),
	@JOB	nvarchar(10),
        @EMPINFO   nvarchar(30) OUTPUT
AS
	UPDATE EMP
	SET 
		ENAME = @ENAME, JOB = @JOB 
	WHERE
		EMPNO = @EMPNO
      SET @EMPINFO = CAST(@EMPNO AS nvarchar) + ' ' + @JOB
      RETURN @EMPNO;

GO

CREATE PROCEDURE SDAC_DeleteEmp  
	@EMPNO	int,
	@Result	int OUTPUT
AS
	DELETE Emp
	WHERE
		EmpNO = @EmpNO
	SET @Result = @EmpNO + 2;

GO

CREATE PROCEDURE "Ten Most High-Paid Employees" AS
BEGIN
    SET ROWCOUNT 10
    SELECT Emp.EName AS TenMostHighPaidEmployees, Emp.SAL
        FROM Emp
        ORDER BY Emp.SAL DESC
    SET ROWCOUNT 0
END;	