
//////////////////////////////////////////////////
//  SQL Server Data Access Components
//  Copyright  1998-2025 Devart. All right reserved.
//  SDAC About Window
//  Created:            24.07.01
//////////////////////////////////////////////////

{$I DacDemo.inc}
unit SdacAbout;

interface
uses
  SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
{$IFDEF MSWINDOWS}
  Windows, ShellApi,
  {$IFNDEF FPC}Jpeg, {$ENDIF}
{$ENDIF}
{$IFDEF FPC}
  LResources,
{$ENDIF}
  Buttons, ExtCtrls;
type
  TSdacAboutForm = class(TForm)
    OKBtn: TButton;
    Image1: TImage;
    Label1: TLabel;
    Label3: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    lbMail: TLabel;
    lbWeb: TLabel;
    Label4: TLabel;
    Bevel1: TBevel;
    Label10: TLabel;
    lbForum: TLabel;
    procedure lbWebClick(Sender: TObject);
    procedure lbMailClick(Sender: TObject);
    procedure lbWebMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure lbMailMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure lbForumMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure lbForumClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SdacAboutForm: TSdacAboutForm;

procedure ShowAbout;

implementation

{$IFNDEF FPC}
{$IFDEF CLR}
{$R *.nfm}
{$ELSE}
{$R *.dfm}
{$ENDIF}
{$ELSE}
{$R *.lfm}
{$ENDIF}

{$IFDEF FPC}
uses LCLIntf;
{$ENDIF}

procedure ShowAbout;
begin
  with TSdacAboutForm.Create(Application) do
  try
    ShowModal;
  finally
    Free;
  end;
end;

procedure TSdacAboutForm.lbWebClick(Sender: TObject);
begin
{$IFDEF FPC}
  OpenURL('https://www.devart.com/sdac');
{$ELSE}
{$IFDEF MSWINDOWS}
  ShellExecute(0, {$IFDEF FPC}PChar{$ENDIF}('open'), 'https://www.devart.com/sdac', '', '', SW_SHOW);
  lbWeb.Font.Color := $FF0000;
{$ENDIF}
{$ENDIF}
end;

procedure TSdacAboutForm.lbMailClick(Sender: TObject);
begin
{$IFDEF FPC}
  OpenURL('mailto:support@devart.com');
{$ELSE}
{$IFDEF MSWINDOWS}
  ShellExecute(0, {$IFDEF FPC}PChar{$ENDIF}('open'), 'mailto:support@devart.com', 'zxczxc', '', SW_SHOW);
  lbMail.Font.Color := $FF0000;
{$ENDIF}
{$ENDIF}
end;

procedure TSdacAboutForm.lbForumClick(Sender: TObject);
begin
{$IFDEF FPC}
  OpenURL('https://support.devart.com/portal/en/community/delphi-data-access-components/sql-server-data-access-components');
{$ELSE}
{$IFDEF MSWINDOWS}
  ShellExecute(0, {$IFDEF FPC}PChar{$ENDIF}('open'), 'https://support.devart.com/portal/en/community/delphi-data-access-components/sql-server-data-access-components', '', '', SW_SHOW);
  lbWeb.Font.Color := $FF0000;
{$ENDIF}
{$ENDIF}
end;

procedure TSdacAboutForm.lbWebMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  lbWeb.Font.Color := $4080FF;
end;

procedure TSdacAboutForm.lbMailMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  lbMail.Font.Color := $4080FF;
end;

procedure TSdacAboutForm.lbForumMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  lbForum.Font.Color := $4080FF;
end;

procedure TSdacAboutForm.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  lbWeb.Font.Color := $FF0000;
  lbMail.Font.Color := $FF0000;
  lbForum.Font.Color := $FF0000;
end;

end.
