unit ConnectDialog;

interface

uses
{$IFDEF MSWINDOWS}
  Windows, 
{$ENDIF}
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, Buttons, Grids, DBGrids, DBCtrls, StdCtrls, ExtCtrls, DBAccess,
  MSAccess, SdacVcl, DemoFrame,
  InheritedConnectForm, MyConnectForm, {$IFDEF FPC}LResources, MemDataSet{$ELSE}MemDS{$ENDIF};

type
  TConnectDialogFrame = class(TDemoFrame)
    DataSource: TDataSource;
    MSQuery: TMSQuery;
    DBGrid: TDBGrid;
    ToolBar: TPanel;
    Panel1: TPanel;
    btOpen: TSpeedButton;
    btClose: TSpeedButton;
    DBNavigator: TDBNavigator;
    Panel3: TPanel;
    rbInherited: TRadioButton;
    rbMy: TRadioButton;
    rbDefault: TRadioButton;
    procedure btOpenClick(Sender: TObject);
    procedure btCloseClick(Sender: TObject);
    procedure rbDefaultClick(Sender: TObject);
    procedure rbMyClick(Sender: TObject);
    procedure rbInheritedClick(Sender: TObject);
  private
    { Private declarations }
  public
    destructor Destroy; override;
    // Demo management
    procedure Initialize; override;
    procedure SetDebug(Value: boolean); override;
  end;

implementation

{$IFNDEF FPC}
{$IFDEF CLR}
{$R *.nfm}
{$ELSE}
{$R *.dfm}
{$ENDIF}
{$ENDIF}

destructor TConnectDialogFrame.Destroy;
begin
  MSQuery.Connection.ConnectDialog.DialogClass := '';
  inherited;
end;


procedure TConnectDialogFrame.btOpenClick(Sender: TObject);
begin
  MSQuery.Open;
end;

procedure TConnectDialogFrame.btCloseClick(Sender: TObject);
begin
  MSQuery.Close;
end;

procedure TConnectDialogFrame.rbDefaultClick(Sender: TObject);
begin
  MSQuery.Connection.ConnectDialog.DialogClass := '';
end;

procedure TConnectDialogFrame.rbMyClick(Sender: TObject);
begin                                                         
  MSQuery.Connection.ConnectDialog.DialogClass := 'TfmMyConnect';
end;

procedure TConnectDialogFrame.rbInheritedClick(Sender: TObject);
begin
  MSQuery.Connection.ConnectDialog.DialogClass := 'TfmInheritedConnect';
end;

// Demo management
procedure TConnectDialogFrame.Initialize;
begin
  inherited;
  MSQuery.Connection := Connection as TMSConnection;
end;

procedure TConnectDialogFrame.SetDebug(Value: boolean);
begin
  MSQuery.Debug:= Value;
end;

{$IFDEF FPC}
initialization
  {$i ConnectDialog.lrs}
{$ENDIF}
end.

