//////////////////////////////////////////////////
//  SQL Server Data Access Components
//  Copyright  1998-2025 Devart. All right reserved.
//  MSNames Editor
//////////////////////////////////////////////////

{$IFNDEF CLR}

{$I Sdac.inc}

unit MSNamesEditor;
{$ENDIF}

interface

uses
{$IFDEF FPC}
  LResources,
{$ENDIF}
{$IFDEF MSWINDOWS}
  Windows, Messages,
{$ENDIF}
  SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, Grids, DBGrids, DBCtrls, Buttons, ExtCtrls, StdCtrls,
  CRTypes, CRFunctions, MSAccess, MSClasses, CREditor, DADualListEditor;

type
  TMSNamesEditorForm = class(TDADualListEditorForm)
  protected
    FConnection: TMSConnection;
    FNames: string;

    procedure DoInit; override;
    procedure DoSave; override;

    function GetComponent: TComponent; override;
    procedure SetComponent(Value: TComponent); override;

    function GetSrcLabelCaption: string; override;
    procedure GetSrcListItems(Items: TStrings); override;
    function GetDestLabelCaption: string; override;
    procedure GetDstListItems(Items: TStrings); override;
  public
    property Connection: TMSConnection read FConnection write FConnection;
    property Names: string read FNames write FNames;
  end;

implementation

{$IFNDEF FPC}
{$IFDEF CLR}
{$R MSNamesEditor.dfm}
{$ELSE}
{$R *.dfm}
{$ENDIF}
{$ELSE}
{$R *.lfm}
{$ENDIF}

{ TMSNamesEditorForm }

procedure TMSNamesEditorForm.DoInit;
begin
  if Connection = nil then
    Abort;
    
  inherited;
end;

procedure TMSNamesEditorForm.DoSave;
var
  List: TStringList;
begin
  List := TStringList.Create;
  try
    AssignStrings(DstList.Items, List);
    Names := MSSQLInfo.NamesFromList(List);
  finally
    List.Free;
  end;
end;

function TMSNamesEditorForm.GetComponent: TComponent;
begin
  Result := FConnection;
end;

procedure TMSNamesEditorForm.SetComponent(Value: TComponent);
begin
  FConnection := Value as TMSConnection;
end;

function TMSNamesEditorForm.GetDestLabelCaption: string;
begin
  Result := 'Selected tables';
end;

procedure TMSNamesEditorForm.GetDstListItems(Items: TStrings);
begin
  MSSQLInfo.NamesToList(Names, Items);
end;

function TMSNamesEditorForm.GetSrcLabelCaption: string;
begin
  Result := 'Available tables';
end;

procedure TMSNamesEditorForm.GetSrcListItems(Items: TStrings);
begin
  Connection.GetTableNames(Items);
end;

end.
