
//////////////////////////////////////////////////
//  SQL Server Data Access Components
//  Copyright  1998-2025 Devart. All right reserved.
//  MSQuery Editor
//////////////////////////////////////////////////

{$IFNDEF CLR}

{$I Sdac.inc}

unit MSQueryEditor;
{$ENDIF}

interface

uses
{$IFDEF FPC}
  LResources,
{$ENDIF}
{$IFDEF MSWINDOWS}
  Windows, 
{$ENDIF}
Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Buttons, ExtCtrls,
  DAQueryEditor;

type

  TMSQueryEditorForm = class(TDAQueryEditorForm)
    btQueryAnalyzer: TBitBtn;
    btManagementStudio: TBitBtn;
    procedure btQueryAnalyzerClick(Sender: TObject);
    procedure btManagementStudioClick(Sender: TObject);
  protected
    procedure DoInit; override;
    procedure DoError(E: Exception); override;
  public
    property Query;
  end;

implementation

{$IFNDEF FPC}
{$IFDEF CLR}
{$R MSQueryEditor.dfm}
{$ELSE}
{$R *.dfm}
{$ENDIF}
{$ELSE}
{$R *.lfm}
{$ENDIF}

uses
  DASQLFrame, DAParamsFrame, MSParamsFrame, DAMacrosFrame, DASPCallFrame,
  MSSPCallFrame, DAUpdateSQLFrame, DASQLGeneratorFrame, DADataTypeMapFrame,
  MSSQLEditor, MSAccess, MSClasses, DBAccess,
  {$IFDEF SDAC}MSDesign,{$ENDIF} DAConditionsFrame;

{ TMSQueryEditorForm }

procedure TMSQueryEditorForm.DoInit;
begin
  FSQLFrame := AddTab(TDASQLFrame, shSQL) as TDASQLFrame;
  FParamsFrame := AddTab(TMSParamsFrame, shParameters) as TDAParamsFrame;
  FMacrosFrame := AddTab(TDAMacrosFrame, shMacros) as TDAMacrosFrame;
  FSPCallFrame := AddTab(TMSSPCallFrame, shGeneratorSPC) as TDASPCallFrame;
  FUpdateSQLFrame := AddTab(TDAUpdateSQLFrame, shEditSQL) as TDAUpdateSQLFrame;
  FSQLGeneratorFrame := AddTab(TDASQLGeneratorFrame, shGenerator) as TDASQLGeneratorFrame;
  FDataTypeMapFrame := AddTab(GetDataTypeMapFrameClass, shDataTypeMap) as TDADataTypeMapFrame;
  FConditionsFrame := AddTab(TDAConditionsFrame, shConditions) as  TDAConditionsFrame;

  inherited;

  btQueryAnalyzer.Visible := {$IFDEF MSWINDOWS}IsServerToolInstalled(stQueryAnalyser){$ELSE}False{$ENDIF};
  if btQueryAnalyzer.Visible and (Query.Connection <> nil) then
    btQueryAnalyzer.Visible := (Query.Connection is TMSConnection) and (TMSConnection(Query.Connection).Options.Provider <> prCompact);

  btManagementStudio.Visible := {$IFDEF MSWINDOWS}IsServerToolInstalled(stManagementStudio){$ELSE}False{$ENDIF};
  if btManagementStudio.Visible and (Query.Connection <> nil) then
    btManagementStudio.Visible := (Query.Connection is TMSConnection) and (TMSConnection(Query.Connection).Options.Provider <> prCompact);

  if btQueryAnalyzer.Visible or btManagementStudio.Visible then
    Constraints.MinWidth := 652;
end;

procedure TMSQueryEditorForm.DoError(E: Exception);
begin
  if E is EDAError then
    MSSQLEditor.DoError(Self, EDAError(E))
  else
    inherited;
end;

procedure TMSQueryEditorForm.btQueryAnalyzerClick(Sender: TObject);
begin
{$IFDEF MSWINDOWS}
  RunServerToolDataSet(stQueryAnalyser, LocalComponent as TCustomMSDataSet);
{$ENDIF}
end;

procedure TMSQueryEditorForm.btManagementStudioClick(Sender: TObject);
begin
{$IFDEF MSWINDOWS}
  RunServerToolDataSet(stManagementStudio, LocalComponent as TCustomMSDataSet);
{$ENDIF}
end;

end.
