
//////////////////////////////////////////////////
//  SQL Server Data Access Components
//  Copyright  1998-2025 Devart. All right reserved.
//  SDAC registration
//////////////////////////////////////////////////

{$I Sdac.inc}
unit MSReg;

interface

procedure Register;

implementation

uses
  Classes, DBAccess, DacReg,
{$IFDEF FPC}
  LResources,
{$ENDIF}
  MSAccess, MSSQLMonitor, MSScript,
{$IFNDEF STD}
  CREncryption, MSLoader, MSDump, MSServiceBroker, {$IFDEF MSWINDOWS}MSCompactConnection,{$ENDIF}
  MSTransaction,
{$ENDIF}
  SdacVcl {$IFDEF VER9P}, Windows{$ENDIF};

{$IFNDEF FPC}
  {$IFDEF VER28P}
    {$R MSDesign28p.res}
  {$ELSE}
    {$IFDEF VER9}
      {$R MSDesign9.res}
    {$ELSE}
      {$R MSDesign.res}
    {$ENDIF}
    {$IFDEF VER10P}
      {$R MSDesign10p.res}
    {$ENDIF}
  {$ENDIF}
{$ENDIF}

procedure Register;
begin
{$IFDEF VER9P}
  RegisterSplashScreen('Devart SQL Server Data Access Components',
                       SDacVersion,
                       LoadBitmap(HInstance, {$IFDEF VER9}'SPLASHGR'{$ENDIF}
                                             {$IFDEF VER10}'SPLASHBL'{$ENDIF}
                                             {$IFDEF VER11}'SPLASHWH'{$ENDIF}
                                             {$IFDEF VER12}'SPLASHWH'{$ENDIF}
                                             {$IFDEF VER14P}'SPLASHBL'{$ENDIF}),
                     {$IFDEF BETA}
                       true, 'Beta'
                     {$ELSE}
                     {$IFDEF RC}
                       false, 'Release Candidate'
                     {$ELSE}
                     {$IFDEF TRIAL}
                       true, 'Trial'
                     {$ELSE} //ORIGINAL
                       false, 'Licensed'
                     {$ENDIF}
                     {$ENDIF}
                     {$ENDIF}
                      );
  RegisterAboutBox('Devart SQL Server Data Access Components',
                   SDacVersion,
                   'http://www.devart.com/sdac/',
                   'Devart SQL Server Data Access Components' + #13#10 +
                   'Copyright 1998 - 2025 Devart. All rights reserved.' + #13#10 +
                   'Web: www.devart.com/sdac/' + #13#10 +
                   'Support: www.devart.com/sdac/support.html',
                   LoadBitmap(HInstance, 'ABOUT'),
                 {$IFDEF BETA}
                   true, 'Beta'
                 {$ELSE}
                 {$IFDEF RC}
                   false, 'Release Candidate'
                 {$ELSE}
                 {$IFDEF TRIAL}
                   true, 'Trial'
                 {$ELSE} //ORIGINAL
                   false, 'Licensed'
                 {$ENDIF}
                 {$ENDIF}
                 {$ENDIF}
                   , 
                 {$IFDEF STD}
                   'Standard edition'
                 {$ELSE}
                   'Professional edition'
                 {$ENDIF}
                  );
{$ENDIF}

{$IFNDEF STD}
  RegisterCRBatchMove;
{$ENDIF}

  RegisterComponents('SDAC', [TMSConnection]);
  RegisterComponents('SDAC', [TMSQuery]);
  RegisterComponents('SDAC', [TMSTable]);
  RegisterComponents('SDAC', [TMSStoredProc]);
  RegisterComponents('SDAC', [TMSSQL]);
  RegisterComponents('SDAC', [TMSScript]);
  RegisterComponents('SDAC', [TMSUpdateSQL]);
  RegisterComponents('SDAC', [TMSDataSource]);

{$IFNDEF STD}
  RegisterComponents('SDAC', [TMSLoader]);
  RegisterComponents('SDAC', [TMSDump]);
  RegisterComponents('SDAC', [TMSServiceBroker]);
  RegisterComponents('SDAC', [TMSMetadata]);
{$ENDIF}

  RegisterComponents('SDAC', [TMSSQLMonitor]);
  RegisterComponents('SDAC', [TMSConnectDialog]);

{$IFNDEF STD}
{$IFDEF MSWINDOWS}
  RegisterComponents('SDAC', [TMSCompactConnection]);
{$ENDIF}
  RegisterComponents('SDAC', [TMSChangeNotification]);
  RegisterComponents('SDAC', [TMSTransaction]);
{$ENDIF}
  RegisterComponents('SDAC', [TMSTableData]);
{$IFNDEF STD}
  RegisterComponents('SDAC', [TMSEncryptor]);
{$ENDIF}
end;

{$IFDEF FPC}
initialization
  {$I MSDesign.lrs}
{$ENDIF}

end.
