
//////////////////////////////////////////////////
//  SQL Server Data Access Components
//  Copyright  1998-2025 Devart. All right reserved.
//  MSSQL Editor
//////////////////////////////////////////////////

{$IFNDEF CLR}

{$I Sdac.inc}

unit MSSQLEditor;
{$ENDIF}
interface

uses
{$IFDEF FPC}
  LResources,
{$ENDIF}
{$IFDEF MSWINDOWS}
  Windows,
{$ENDIF}
  Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Buttons, ExtCtrls,
{$IFDEF DBTOOLS}
  DBToolsClient,
{$ENDIF}
  MSClasses, DBAccess, DASQLComponentEditor;

type
  TMSSQLEditorForm = class(TDASQLEditorForm)
    btQueryAnalyzer: TButton;
    btManagementStudio: TButton;
    procedure btQueryAnalyzerClick(Sender: TObject);
    procedure btManagementStudioClick(Sender: TObject);
  protected
    procedure DoInit; override;
    procedure DoError(E: Exception); override;
  public
    property SQL;
  end;

procedure DoError(Sender: TDASQLEditorForm; E: EDAError);

implementation

{$IFNDEF FPC}
{$IFDEF CLR}
{$R MSSQLEditor.dfm}
{$ELSE}
{$R *.dfm}
{$ENDIF}
{$ELSE}
{$R *.lfm}
{$ENDIF}

uses
  MSAccess, DASQLFrame, DAParamsFrame, MSParamsFrame, DAMacrosFrame, DASPCallFrame,
  MSSPCallFrame{$IFDEF SDAC}, MSDesign{$ENDIF};

procedure DoError(Sender: TDASQLEditorForm; E: EDAError);
begin
  Sender.ActivateFrame(Sender.SQLFrame);
{$IFDEF DBTOOLS}
  if Assigned(DBTools) and DBTools.HasDACSqlEditorFrame(Sender.SQLFrame.meSQL) then
    Sender.ActiveControl := DBTools.GetDACSqlEditorFrame(Sender.SQLFrame.meSQL)
  else
{$ENDIF}
    Sender.ActiveControl := Sender.SQLFrame.meSQL;
end;

{ TMSSQLEditorForm }

procedure TMSSQLEditorForm.DoError(E: Exception);
begin
  if E is EDAError then
    {$IFDEF CLR}Devart.SDac.Design.{$ENDIF}MSSQLEditor.DoError(Self, EDAError(E))
  else
    inherited;
end;

procedure TMSSQLEditorForm.DoInit;
begin
  FSQLFrame := AddTab(TDASQLFrame, shSQL) as TDASQLFrame;
  FParamsFrame := AddTab(TMSParamsFrame, shParameters) as TDAParamsFrame;
  FMacrosFrame := AddTab(TDAMacrosFrame, shMacros) as TDAMacrosFrame;
  FSPCallFrame := AddTab(TMSSPCallFrame, shGeneratorSPC) as TDASPCallFrame;

  inherited;

  btQueryAnalyzer.Visible := {$IFDEF MSWINDOWS}IsServerToolInstalled(stQueryAnalyser){$ELSE}False{$ENDIF};
  if btQueryAnalyzer.Visible and (SQL.Connection <> nil) then
    btQueryAnalyzer.Visible := (SQL.Connection is TMSConnection) and (TMSConnection(SQL.Connection).Options.Provider <> prCompact);

  btManagementStudio.Visible := {$IFDEF MSWINDOWS}IsServerToolInstalled(stManagementStudio){$ELSE}False{$ENDIF};
  if btManagementStudio.Visible and (SQL.Connection <> nil) then
    btManagementStudio.Visible := (SQL.Connection is TMSConnection) and (TMSConnection(SQL.Connection).Options.Provider <> prCompact);
end;

procedure TMSSQLEditorForm.btQueryAnalyzerClick(Sender: TObject);
begin
{$IFDEF MSWINDOWS}
  RunServerToolMSSQL(stQueryAnalyser, LocalComponent as TMSSQL);
{$ENDIF}
end;

procedure TMSSQLEditorForm.btManagementStudioClick(Sender: TObject);
begin
{$IFDEF MSWINDOWS}
  RunServerToolMSSQL(stManagementStudio, LocalComponent as TMSSQL);
{$ENDIF}
end;

end.
