
//////////////////////////////////////////////////
//  SQL Server Data Access Components
//  Copyright  1998-2025 Devart. All right reserved.
//  MSTable Editor
//////////////////////////////////////////////////

{$IFNDEF CLR}

{$I Sdac.inc}

unit MSTableEditor;
{$ENDIF}
interface
uses
  SysUtils, Classes,
{$IFDEF MSWINDOWS}
  Windows, Messages,
{$ENDIF}
  Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ExtCtrls, Buttons,
{$IFDEF FPC}
  LResources,
{$ENDIF}
  DATableEditor, DATableSQLFrame, DADataTypeMapFrame, DAConditionsFrame;

type
  TMSTableEditorForm = class(TDATableEditorForm)
  protected
    procedure DoInit; override;
  end;

implementation

{$IFNDEF FPC}
{$IFDEF CLR}
{$R MSTableEditor.dfm}
{$ELSE}
{$R *.dfm}
{$ENDIF}
{$ELSE}
{$R *.lfm}
{$ENDIF}

{ TMSTableEditorForm }

procedure TMSTableEditorForm.DoInit;
begin
  FDataTypeMapFrame := AddTab(GetDataTypeMapFrameClass, shDataTypeMap) as TDADataTypeMapFrame;
  FConditionsFrame := AddTab(TDAConditionsFrame, shConditions) as  TDAConditionsFrame;

  inherited;
end;

end.
