type

{ TMSConnectDialog }

{$IFDEF VER16P}
  [ComponentPlatformsAttribute(pidWin32 or pidWin64{$IFDEF VER29P} or pidWin64x{$ENDIF}{$IFNDEF STD} or pidOSX32{$IFDEF VER25P} or pidLinux64{$IFDEF VER26P} or pidOSX64{$ENDIF}{$ENDIF}{$ENDIF})]
{$ENDIF}
  {$IFDEF FMX}TMSConnectDialogFmx{$ELSE}TMSConnectDialog{$ENDIF} = class(TCustomConnectDialog)
  private
    FCachedServerList: TStrings;

    FDatabaseOption: TConnectDialogOption;
    FPortOption: TConnectDialogOption;
    FAuthenticationOption: TConnectDialogOption;

    function GetDatabaseLabel: string;
    procedure SetDatabaseLabel(Value: string);

    procedure SetDatabaseOption(Value: TConnectDialogOption);
    procedure SetPortOption(Value: TConnectDialogOption);
    procedure SetAuthenticationOption(Value: TConnectDialogOption);

    function GetConnection: TCustomMSConnection;
  protected
    procedure SetLabelSet(Value: TLabelSet); override;
    function DefDialogClass: TClass; override;
  {$IFDEF MSWINDOWS}
    function GetKeyPath: string; override;
    function GetServerStoreName: string; override;

    procedure SaveInfoToRegistry(Registry: TRegistry); override;
    procedure LoadInfoFromRegistry(Registry: TRegistry); override;
  {$ENDIF}

    procedure ReadDatabaseCaptionProperty(Reader: TReader);
    procedure DefineProperties(Filer: TFiler); override;
  public
    constructor Create(Owner: TComponent); override;
    property Connection: TCustomMSConnection read GetConnection;
    procedure GetServerList(List: TStrings); override;
    destructor Destroy; override;
    function Execute: boolean; override;

    procedure GetOptions(var Options: TConnectDialogOptionArray; Ordered: Boolean = True); override;

    property DatabaseLabel: string read GetDatabaseLabel write SetDatabaseLabel;
  published
    property Retries;
    property SavePassword;
    property DialogClass;

    property Caption;
    property ConnectButton;
    property CancelButton;

    property Server;
    property UserName;
    property Password;
    property Database: TConnectDialogOption read FDatabaseOption write SetDatabaseOption;
    property Port: TConnectDialogOption read FPortOption write SetPortOption;
    property Authentication: TConnectDialogOption read FAuthenticationOption write SetAuthenticationOption;

    property LabelSet;
    property StoreLogInfo;
  end;

implementation

uses
  {$IFDEF VER16P}{$IFDEF FMX}FMX.Types,{$ELSE}Controls,{$ENDIF}{$ENDIF}
  DAConsts, TypInfo;

function DefConnectDialogClass: TClass;
begin
  Result := {$IFDEF FMX}TMSConnectDialogFmx{$ELSE}TMSConnectDialog{$ENDIF};
end;

const
  KeyPath = '\SOFTWARE\Devart\SDAC\';

{ TMSConnectDialog }

function {$IFDEF FMX}TMSConnectDialogFmx{$ELSE}TMSConnectDialog{$ENDIF}.DefDialogClass: TClass; 
begin
  Result := TMSConnectForm;
end;
    
{$IFDEF MSWINDOWS}
function {$IFDEF FMX}TMSConnectDialogFmx{$ELSE}TMSConnectDialog{$ENDIF}.GetKeyPath: string;
begin
  Result := KeyPath;
end;
{$ENDIF}

constructor {$IFDEF FMX}TMSConnectDialogFmx{$ELSE}TMSConnectDialog{$ENDIF}.Create(Owner: TComponent);
begin
  inherited;

  FCachedServerList := TStringList.Create;
  Server.Order := 0;
  UserName.Order := 3;
  Password.Order := 4;
  FDatabaseOption := TConnectDialogOption.Create(Self, okDatabase, 5);
  FPortOption := TConnectDialogOption.Create(Self, okPort, 1, False);
  FAuthenticationOption := TConnectDialogOption.Create(Self, okAuthentication, 2, False);
  LabelSet := lsEnglish;
end;

destructor {$IFDEF FMX}TMSConnectDialogFmx{$ELSE}TMSConnectDialog{$ENDIF}.Destroy;
begin
  FCachedServerList.Free;
  FDatabaseOption.Free;
  FPortOption.Free;
  FAuthenticationOption.Free;

  inherited;
end;

function {$IFDEF FMX}TMSConnectDialogFmx{$ELSE}TMSConnectDialog{$ENDIF}.Execute: boolean;
var
  OldDatabase: string;
  OldPort: integer;
  OldAuthentication: TMSAuthentication;
begin
  if Connection = nil then
    DatabaseError(SConnectionNotDefined);
  Assert(Connection is TCustomMSConnection);

  Result := False;
  OldDatabase := TCustomMSConnection(Connection).Database;
  if Connection is TMSConnection then begin
    OldPort := TMSConnection(Connection).Port;
    OldAuthentication := TMSConnection(Connection).Authentication;
  end
  else begin // skip warning
    OldPort := 0;
    OldAuthentication := auServer;
  end;
  try
    Result := inherited Execute;
  finally
    if not Result then begin
      TCustomMSConnection(Connection).Database := OldDatabase;
      if Connection is TMSConnection then begin
        TMSConnection(Connection).Port := OldPort;
        TMSConnection(Connection).Authentication := OldAuthentication;
      end;
    end;
  end;
end;

procedure {$IFDEF FMX}TMSConnectDialogFmx{$ELSE}TMSConnectDialog{$ENDIF}.SetLabelSet(Value: TLabelSet);
begin
  inherited SetLabelSet(Value);

  InSetLabelSet := True;
  try
  {$IFDEF WIN32_64}
    if Value <> lsCustom then begin
      FDatabaseOption.Caption := GetString(6);
      FPortOption.Caption := GetString(7);
    end;
  {$ELSE}
      FDatabaseOption.Caption := 'Database';
      FPortOption.Caption := 'Port';
  {$ENDIF}
    FAuthenticationOption.Caption := 'Authentication';
  finally
    InSetLabelSet := False;
  end;
end;

procedure {$IFDEF FMX}TMSConnectDialogFmx{$ELSE}TMSConnectDialog{$ENDIF}.GetOptions(var Options: TConnectDialogOptionArray; Ordered: Boolean = True);
begin
  SetLength(Options, 6);
  Options[0] := UserName;
  Options[1] := Password;
  Options[2] := Server;
  Options[3] := Database;
  Options[4] := Port;
  Options[5] := Authentication;
  inherited GetOptions(Options, Ordered);
end;

procedure {$IFDEF FMX}TMSConnectDialogFmx{$ELSE}TMSConnectDialog{$ENDIF}.ReadDatabaseCaptionProperty(Reader: TReader);
begin
  FDatabaseOption.Caption := Reader.ReadString;
end;

procedure {$IFDEF FMX}TMSConnectDialogFmx{$ELSE}TMSConnectDialog{$ENDIF}.DefineProperties(Filer: TFiler);
begin
  inherited;
  Filer.DefineProperty('DatabaseLabel', ReadDatabaseCaptionProperty, nil, False);
end;

{$IFDEF MSWINDOWS}
function {$IFDEF FMX}TMSConnectDialogFmx{$ELSE}TMSConnectDialog{$ENDIF}.GetServerStoreName: string;
begin
  Result := 'Server';
end;

procedure {$IFDEF FMX}TMSConnectDialogFmx{$ELSE}TMSConnectDialog{$ENDIF}.SaveInfoToRegistry(Registry: TRegistry);
begin
  inherited;

  if Database.Visible then
    Registry.WriteString('Database', Connection.Database)
  else
    Registry.DeleteValue('Database');

  if Connection is TMSConnection then begin
    if Port.Visible then
      Registry.WriteInteger('Port', TMSConnection(Connection).Port)
    else
      Registry.DeleteValue('Port');

    if Authentication.Visible then
      Registry.WriteString('Authentication', GetEnumName(TypeInfo(TMSAuthentication), integer(TMSConnection(Connection).Authentication)))
    else
      Registry.DeleteValue('Authentication');
  end;
end;

procedure {$IFDEF FMX}TMSConnectDialogFmx{$ELSE}TMSConnectDialog{$ENDIF}.LoadInfoFromRegistry(Registry: TRegistry);
begin
  inherited;

  if Database.Visible and Registry.ValueExists('Database') then
    TCustomMSConnection(Connection).Database := Registry.ReadString('Database');

  if Connection is TMSConnection then begin
    if Port.Visible and Registry.ValueExists('Port') then
      TMSConnection(Connection).Port := Registry.ReadInteger('Port');

    if Authentication.Visible and Registry.ValueExists('Authentication') then
      TMSConnection(Connection).Authentication := TMSAuthentication(GetEnumValue(TypeInfo(TMSAuthentication), Registry.ReadString('Authentication')));
  end;
end;
{$ENDIF}

procedure {$IFDEF FMX}TMSConnectDialogFmx{$ELSE}TMSConnectDialog{$ENDIF}.GetServerList(List: TStrings);
begin
  if FCachedServerList.Count = 0 then begin
    MSAccess.GetServerList(List);
    FCachedServerList.Assign(List);
  end else
    List.Assign(FCachedServerList);
end;

procedure {$IFDEF FMX}TMSConnectDialogFmx{$ELSE}TMSConnectDialog{$ENDIF}.SetDatabaseOption(Value: TConnectDialogOption);
begin
  FDatabaseOption.Assign(Value);
end;

procedure {$IFDEF FMX}TMSConnectDialogFmx{$ELSE}TMSConnectDialog{$ENDIF}.SetPortOption(Value: TConnectDialogOption);
begin
  FPortOption.Assign(Value);
end;

procedure {$IFDEF FMX}TMSConnectDialogFmx{$ELSE}TMSConnectDialog{$ENDIF}.SetAuthenticationOption(Value: TConnectDialogOption);
begin
  FAuthenticationOption.Assign(Value);
end;

function {$IFDEF FMX}TMSConnectDialogFmx{$ELSE}TMSConnectDialog{$ENDIF}.GetDatabaseLabel: string;
begin
  Result := FDatabaseOption.Caption;
end;

procedure {$IFDEF FMX}TMSConnectDialogFmx{$ELSE}TMSConnectDialog{$ENDIF}.SetDatabaseLabel(Value: string);
begin
  FDatabaseOption.Caption := Value;
end;

function {$IFDEF FMX}TMSConnectDialogFmx{$ELSE}TMSConnectDialog{$ENDIF}.GetConnection: TCustomMSConnection;
begin
  Result := (inherited Connection) as TCustomMSConnection;
end;

initialization
{$IFDEF FMX}
  if not Assigned(DefConnectDialogClassProc) then
{$ENDIF}
    DefConnectDialogClassProc := DefConnectDialogClass;
{$IFDEF VER16P}
{$IFDEF FMX}
  GroupDescendentsWith(TMSConnectDialogFmx, TFmxObject);
{$ELSE}
  GroupDescendentsWith(TMSConnectDialog, TControl);
{$ENDIF}
{$ENDIF}

end.
