unit Query;

interface

uses
{$IFDEF FPC}
  LResources,
{$ENDIF}
{$IFDEF MSWINDOWS}
  Windows, Messages,
{$ENDIF}
  SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DBCtrls, ExtCtrls, Db, Grids, DBGrids, StdCtrls, ToolWin, ComCtrls, Buttons,
{$IFNDEF FPC}
  MemDS,
{$ELSE}
  MemDataSet,
{$ENDIF}
  DBAccess, VirtualTable, VirtualQuery,
  DemoFrame, VirtualDacDemoForm;

type
  TQueryFrame = class(TDemoFrame)
    DataSource: TDataSource;
    DBGrid: TDBGrid;
    Panel9: TPanel;
    btRefreshRecord: TSpeedButton;
    DBNavigator: TDBNavigator;
    Splitter1: TSplitter;
    ToolBar: TPanel;
    Panel1: TPanel;
    btClose: TSpeedButton;
    btOpen: TSpeedButton;
    Panel2: TPanel;
    cbRefreshBeforeEdit: TCheckBox;
    cbRefreshAfterInsert: TCheckBox;
    cbRefreshAfterUpdate: TCheckBox;
    Panel5: TPanel;
    StaticText1: TLabel;
    edFetchRows: TEdit;
    Panel6: TPanel;
    Label5: TLabel;
    edFilter: TEdit;
    cbFiltered: TCheckBox;
    Panel7: TPanel;
    edUpdatingTable: TEdit;
    Label2: TLabel;
    Memo: TMemo;
    btPrepare: TSpeedButton;
    btUnPrepare: TSpeedButton;
    btExecute: TSpeedButton;
    btSaveToXML: TSpeedButton;
    SaveDialog: TSaveDialog;
    Panel3: TPanel;
    cbFetchAll: TCheckBox;
    Panel4: TPanel;
    VirtualQuery: TVirtualQuery;
    VirtualTableEMP: TVirtualTable;
    VirtualTableDEPT: TVirtualTable;
    procedure btOpenClick(Sender: TObject);
    procedure btCloseClick(Sender: TObject);
    procedure btRefreshRecordClick(Sender: TObject);
    procedure DataSourceDataChange(Sender: TObject; Field: TField);
    procedure DataSourceStateChange(Sender: TObject);
    procedure cbFilteredClick(Sender: TObject);
    procedure cbRefreshOptionsClick(Sender: TObject);
    procedure VirtualQueryAfterOpen(DataSet: TDataSet);
    procedure edFetchRowsExit(Sender: TObject);
    procedure btPrepareClick(Sender: TObject);
    procedure btUnPrepareClick(Sender: TObject);
    procedure btExecuteClick(Sender: TObject);
    procedure btSaveToXMLClick(Sender: TObject);
    procedure cbDMLRefreshClick(Sender: TObject);
    procedure cbFetchAllClick(Sender: TObject);
    procedure edUpdatingTableExit(Sender: TObject);
    procedure cmbLockModeChange(Sender: TObject);
    procedure edFilterExit(Sender: TObject);
  private
    { Private declarations }
    procedure AssignProperties(PropertyNameToSet: string = '');
    procedure ShowState;
  public
    // Demo management
    procedure Initialize; override;
    procedure SetDebug(Value: boolean); override;
  end;

implementation

{$IFNDEF FPC}
{$R *.dfm}
{$ENDIF}

{$IFDEF FPC}
uses fileutil;
{$ENDIF}

procedure TQueryFrame.ShowState;
var
  St: string;

  procedure AddSt(S:string);
  begin
    if St <> '' then
      St := St + ', ';
    St := St + S;
  end;

begin
  St := '';

  if VirtualQuery.Prepared then begin
    AddSt('Prepared');

    if VirtualQuery.IsQuery then
      AddSt('IsQuery');
  end;

  if VirtualQuery.Active then
    AddSt('Active')
  else
    AddSt('Inactive');

  if VirtualQuery.Executing then
    AddSt('Executing');

  if VirtualQuery.Fetching then
    AddSt('Fetching');

  edUpdatingTable.Text := VirtualQuery.UpdatingTable;

  VirtualDacForm.StatusBar.Panels[2].Text := St;
end;

procedure TQueryFrame.AssignProperties(PropertyNameToSet: string = '');  // empty string means all properties
begin
  if CheckProperty('FetchRows', PropertyNameToSet) then
    try
      VirtualQuery.FetchRows := StrToInt(edFetchRows.Text);
    except
      edFetchRows.SetFocus;
      raise;
    end;

  if CheckProperty('FetchAll', PropertyNameToSet) then
    try
      VirtualQuery.FetchAll := cbFetchAll.Checked;
    finally
      cbFetchAll.Checked := VirtualQuery.FetchAll;
    end;

  if CheckProperty('UpdatingTable', PropertyNameToSet) then
    try
      VirtualQuery.UpdatingTable := edUpdatingTable.Text;
    except
      edUpdatingTable.SetFocus;
      raise;
    end;

  if CheckProperty('Filter', PropertyNameToSet) then
    VirtualQuery.Filter := edFilter.Text;

  if CheckProperty('Filtered', PropertyNameToSet) then
    try
      VirtualQuery.Filtered := cbFiltered.Checked;
    finally
      cbFiltered.Checked := VirtualQuery.Filtered;
    end;

  if CheckProperty('SQL', PropertyNameToSet) then
    if Trim(VirtualQuery.SQL.Text) <> Trim(Memo.Lines.Text) then
      VirtualQuery.SQL.Assign(Memo.Lines);

  if CheckProperty('RefreshOptions', PropertyNameToSet) then begin
    if cbRefreshBeforeEdit.Checked then
      VirtualQuery.RefreshOptions := VirtualQuery.RefreshOptions + [roBeforeEdit]
    else
      VirtualQuery.RefreshOptions := VirtualQuery.RefreshOptions - [roBeforeEdit];
    if cbRefreshAfterInsert.Checked then
      VirtualQuery.RefreshOptions := VirtualQuery.RefreshOptions + [roAfterInsert]
    else
      VirtualQuery.RefreshOptions := VirtualQuery.RefreshOptions - [roAfterInsert];
    if cbRefreshAfterUpdate.Checked then
      VirtualQuery.RefreshOptions := VirtualQuery.RefreshOptions + [roAfterUpdate]
    else
      VirtualQuery.RefreshOptions := VirtualQuery.RefreshOptions - [roAfterUpdate];
  end;
end;

procedure TQueryFrame.btOpenClick(Sender: TObject);
begin
  try
    AssignProperties;
    VirtualQuery.Open;
  finally
    ShowState;
  end;
end;

procedure TQueryFrame.btCloseClick(Sender: TObject);
begin
  VirtualQuery.Close;
  ShowState;
end;

procedure TQueryFrame.btRefreshRecordClick(Sender: TObject);
begin
  VirtualQuery.RefreshRecord;
end;

procedure TQueryFrame.DataSourceStateChange(Sender: TObject);
begin
  VirtualDacForm.StatusBar.Panels[1].Text := 'Record ' + IntToStr(VirtualQuery.RecNo) + ' of ' + IntToStr(VirtualQuery.RecordCount);
end;

procedure TQueryFrame.DataSourceDataChange(Sender: TObject; Field: TField);
begin
  DataSourceStateChange(nil);
end;

procedure TQueryFrame.cbFilteredClick(Sender: TObject);
begin
  AssignProperties('Filtered');
end;

procedure TQueryFrame.edFilterExit(Sender: TObject);
begin
  AssignProperties('Filter');
end;

procedure TQueryFrame.cbRefreshOptionsClick(Sender: TObject);
begin
  AssignProperties('RefreshOptions');
end;

procedure TQueryFrame.cbDMLRefreshClick(Sender: TObject);
begin
  AssignProperties('DMLRefresh');
end;

procedure TQueryFrame.cbFetchAllClick(Sender: TObject);
begin
  AssignProperties('FetchAll');
end;

procedure TQueryFrame.edFetchRowsExit(Sender: TObject);
begin
  AssignProperties('FetchRows');
end;

procedure TQueryFrame.edUpdatingTableExit(Sender: TObject);
begin
  AssignProperties('UpdatingTable');
end;

procedure TQueryFrame.cmbLockModeChange(Sender: TObject);
begin
  AssignProperties('LockMode');
end;

procedure TQueryFrame.VirtualQueryAfterOpen(DataSet: TDataSet);
begin
  ShowState;
end;

procedure TQueryFrame.btPrepareClick(Sender: TObject);
begin
  try
    AssignProperties;
    VirtualQuery.Prepare;
  finally
    ShowState;
  end;
end;

procedure TQueryFrame.btUnPrepareClick(Sender: TObject);
begin
  VirtualQuery.UnPrepare;
  ShowState;
end;

procedure TQueryFrame.btExecuteClick(Sender: TObject);
begin
  try
    AssignProperties;
    VirtualQuery.Execute;
  finally
    ShowState;
  end;
end;

procedure TQueryFrame.btSaveToXMLClick(Sender: TObject);
begin
  if SaveDialog.Execute then
    VirtualQuery.SaveToXML(SaveDialog.FileName);
end;

// Demo management
procedure TQueryFrame.Initialize;
begin
  inherited;
{$IFDEF FPC}
  VirtualTableEMP.LoadFromFile(ProgramDirectory + 'EMP.xml');
{$ELSE}
  VirtualTableEMP.LoadFromFile('EMP.xml');
{$ENDIF}
  VirtualTableEMP.Open;
{$IFDEF FPC}
  VirtualTableDEPT.LoadFromFile(ProgramDirectory + 'DEPT.xml');
{$ELSE}
  VirtualTableDEPT.LoadFromFile('DEPT.xml');
{$ENDIF}
  VirtualTableDEPT.Open;
  VirtualQuery.SQL.Text := 'select EMP.*, DEPT.DNAME from EMP JOIN DEPT ON DEPT.DEPTNO = EMP.DEPTNO';

  edFetchRows.Text := IntToStr(VirtualQuery.FetchRows);

  cbRefreshBeforeEdit.Checked := roBeforeEdit in VirtualQuery.RefreshOptions;
  cbRefreshAfterInsert.Checked := roAfterInsert in VirtualQuery.RefreshOptions;
  cbRefreshAfterUpdate.Checked := roAfterUpdate in VirtualQuery.RefreshOptions;

  edFilter.Text := VirtualQuery.Filter;
  cbFiltered.Checked := VirtualQuery.Filtered;

  Memo.Lines.Text := VirtualQuery.SQL.Text;
end;

procedure TQueryFrame.SetDebug(Value: boolean);
begin
  VirtualQuery.Debug := Value;
end;

{$IFDEF FPC}
initialization
  {$i Query.lrs}
{$ENDIF}

end.

