
//////////////////////////////////////////////////
//  SQLite Data Access Components
//  Copyright  2025 Devart. All right reserved.
//  LiteDAC About Window
//////////////////////////////////////////////////

{$I DacDemo.inc}
unit VirtualDacAbout;

interface
uses
  SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
{$IFDEF MSWINDOWS}
  Windows, ShellApi,
  {$IFNDEF FPC}Jpeg, {$ENDIF}
{$ENDIF}
{$IFDEF FPC}
  LResources,
{$ENDIF}
  Buttons, ExtCtrls;
type
  TVirtualDacAboutForm = class(TForm)
    OKBtn: TButton;
    Image1: TImage;
    Label1: TLabel;
    Label3: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    lbMail: TLabel;
    lbWeb: TLabel;
    Label4: TLabel;
    Bevel1: TBevel;
    Label10: TLabel;
    lbForum: TLabel;
    procedure lbWebClick(Sender: TObject);
    procedure lbMailClick(Sender: TObject);
    procedure lbWebMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure lbMailMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure lbForumMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure lbForumClick(Sender: TObject);
  private
  public
  end;

var
  VirtualDacAboutForm: TVirtualDacAboutForm;

procedure ShowAbout;

implementation

{$IFNDEF FPC}
{$IFDEF CLR}
{$R *.nfm}
{$ELSE}
{$R *.dfm}
{$ENDIF}
{$ENDIF}

{$IFDEF FPC}
uses LCLIntf;
{$ENDIF}

procedure ShowAbout;
begin
  with TVirtualDacAboutForm.Create(Application) do
  try
    ShowModal;
  finally
    Free;
  end;
end;

procedure TVirtualDacAboutForm.lbWebClick(Sender: TObject);
begin
{$IFDEF FPC}
  OpenURL('https://www.devart.com/virtualdac');
{$ELSE}
{$IFDEF MSWINDOWS}
  ShellExecute(0, {$IFDEF FPC}PChar{$ENDIF}('open'), 'https://www.devart.com/virtualdac', '', '', SW_SHOW);
  lbWeb.Font.Color := $FF0000;
{$ENDIF}
{$ENDIF}
end;

procedure TVirtualDacAboutForm.lbMailClick(Sender: TObject);
begin
{$IFDEF FPC}
  OpenURL('mailto:support@devart.com');
{$ELSE}
{$IFDEF MSWINDOWS}
  ShellExecute(0, {$IFDEF FPC}PChar{$ENDIF}('open'), 'mailto:support@devart.com', '', '', SW_SHOW);
  lbMail.Font.Color := $FF0000;
{$ENDIF}
{$ENDIF}
end;

procedure TVirtualDacAboutForm.lbForumClick(Sender: TObject);
begin
{$IFDEF FPC}
  OpenURL('https://support.devart.com/portal/en/community/delphi-data-access-components/virtualdac');
{$ELSE}
{$IFDEF MSWINDOWS}
  ShellExecute(0, {$IFDEF FPC}PChar{$ENDIF}('open'), 'https://support.devart.com/portal/en/community/delphi-data-access-components/virtualdac', '', '', SW_SHOW);
  lbWeb.Font.Color := $FF0000;
{$ENDIF}
{$ENDIF}
end;

procedure TVirtualDacAboutForm.lbWebMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  lbWeb.Font.Color := $4080FF;
end;

procedure TVirtualDacAboutForm.lbMailMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  lbMail.Font.Color := $4080FF;
end;

procedure TVirtualDacAboutForm.lbForumMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  lbForum.Font.Color := $4080FF;
end;

procedure TVirtualDacAboutForm.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  lbWeb.Font.Color := $FF0000;
  lbMail.Font.Color := $FF0000;
  lbForum.Font.Color := $FF0000;
end;

{$IFDEF FPC}
initialization
  {$i VirtualDacAbout.lrs}
{$ENDIF}

end.
