{$I DacDemo.inc}
unit VirtualDacDemoForm;

interface

uses
  SysUtils, Classes, DB, Variants,
{$IFDEF FPC}
  LResources,
{$ENDIF}
{$IFDEF MSWINDOWS}
  Windows, Messages,
{$ENDIF}
  Graphics, Controls, Forms,
  Dialogs, Menus, ImgList, StdCtrls, ComCtrls, Buttons, ExtCtrls, ToolWin,
  VirtualDacAbout, DemoFrame, DemoForm, DemoBase, DBAccess;

type
  TVirtualDacForm = class(TDemoForm)
    procedure lbAboutClick(Sender: TObject); override;
    procedure FormResize(Sender: TObject);
    procedure sbConnectClick(Sender: TObject);
    procedure FormCreate(Sender: TObject); override;
    procedure FormDestroy(Sender: TObject);
  private
  protected
    //Product customization
    function GetConnection: TCustomDAConnection; override;
    function ApplicationTitle: string; override;
    function ProductName: string; override;
    procedure RegisterDemos; override;

    procedure InitializeDemoFrame(Frame: TDemoFrame; DemoType: TDemoType); override;
  public
    function ProductColor: TColor; override;
    procedure ExecCreateScript; override;
    procedure ExecDropScript; override;
  end;

var
  VirtualDacForm: TVirtualDacForm;

implementation

uses
  Query, MasterDetail;

{$IFNDEF FPC}
{$R *.dfm}
{$ENDIF}

function TVirtualDacForm.GetConnection: TCustomDAConnection;
begin
  Result := nil;
end;

function TVirtualDacForm.ProductColor: TColor;
begin
  Result := $006E5200;
end;

procedure TVirtualDacForm.ExecCreateScript;
begin
end;

procedure TVirtualDacForm.ExecDropScript;
begin
end;

function TVirtualDacForm.ApplicationTitle: string;
begin
  Result := 'VirtualDAC demos';
end;

function TVirtualDacForm.ProductName: string;
begin
  Result := 'VirtualDAC';
end;

procedure TVirtualDacForm.RegisterDemos;
begin
  Demos.RegisterCategory(ProductName + ' Demo', ProductName + ' Demo');
  Demos.RegisterCategory('Working with components', 'Working with components');
  Demos.RegisterCategory('General demos', 'General demos');

  Demos.RegisterDemo('Query', 'Using TVirtualQuery component', 'Demonstrates working with TVirtualQuery, which is one of the most useful VirtualDAC components. Includes many TVirtualQuery usage scenarios. Demonstrates how to execute queries ' +
    'and how to edit data and export it to XML files. Note: This is a very good introductory demo. We recommend starting here when first becoming familiar with VirtualDAC.',
    'Working with components', TQueryFrame, 6);
  Demos.RegisterDemo('MasterDetail', 'Master/detail relationship', 'Uses TVirtualQuery functionality to work with master/detail relationships. ' +
    'This sample shows how to use local master/detail functionality. Demonstrates different kinds of master/detail linking, including linking by SQL, by simple fields, and by calculated fields.',
    'General demos', TMasterDetailFrame, 1);

  Demos.RegisterCategory('', '', -1, True);
end;

procedure TVirtualDacForm.lbAboutClick(Sender: TObject);
begin
  inherited;

  ShowAbout;
end;

procedure TVirtualDacForm.InitializeDemoFrame(Frame: TDemoFrame;
  DemoType: TDemoType);
begin
  inherited;
end;

procedure TVirtualDacForm.FormCreate(Sender: TObject);
begin
  SetLength(History, MAX_HISTORY_SIZE);
  HistoryIndex := -1;
  Demos := TDemos.Create(TreeView.Items);
  RegisterDemos;
{$IFDEF XPMAN}
  if GetIsXPMan then begin
    ReplaceFlatStyle(Self, False);
    pnTopLabel.Color := ProductColor;
  end;
{$ENDIF}

{$IFDEF USE_SYNEDIT}
  SourceBrowser := TSynMemo.Create(pnSource);

  SourceBrowser.Highlighter := TSynPasSyn.Create(SourceBrowser);
  SourceBrowser.Options := [eoAltSetsColumnMode, eoAutoIndent, eoAutoSizeMaxScrollWidth, eoDisableScrollArrows, eoDragDropEditing, eoDropFiles, eoEnhanceEndKey, eoGroupUndo, eoHideShowScrollbars, eoKeepCaretX, eoShowScrollHint, eoSmartTabDelete, eoSmartTabs, eoTabIndent, eoTabsToSpaces];
  with SourceBrowser.Gutter do begin
    Visible := True;
    AutoSize := True;
    DigitCount := 3;
    LeftOffset := 0;
    RightOffset := 0;
    ShowLineNumbers := True;
    Width := 1;
 end;
{$ELSE}
  SourceBrowser := TMemo.Create(pnSource);
  SourceBrowser.ScrollBars := ssVertical;
  SourceBrowser.Font.Name := 'Courier New';
  SourceBrowser.Font.Size := 10;
{$ENDIF}
  with SourceBrowser do begin
    Parent := pnSource;
    Align := alClient;
    ReadOnly := True;
  end;
  Resize;
  TreeView.Items[0].Expand(True);
  TreeView.Items[0].Selected := True;
  SelectDemo;
end;

procedure TVirtualDacForm.FormDestroy(Sender: TObject);
begin
  SetLength(History, 0);
  Demos.Free;
end;

procedure TVirtualDacForm.FormResize(Sender: TObject);
begin
  inherited;

  lbAbout.Left := lbAbout.Parent.ClientWidth - 132;
end;

procedure TVirtualDacForm.sbConnectClick(Sender: TObject);
begin
  //
end;

{$IFDEF FPC}
initialization
  {$i VirtualDacDemoForm.lrs}
{$ENDIF}

end.

