unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DBCtrls, ExtCtrls, Grids, DBGrids, StdCtrls, ToolWin, ComCtrls, Variants,
  DB, MemDS, VirtualTable;
  
type
  TfmMain = class(TForm)
    DBGrid: TDBGrid;
    ToolBar: TToolBar;
    btOpen: TButton;
    DBNavigator: TDBNavigator;
    btClose: TButton;
    btAutoFill: TButton;
    DBMemo: TDBMemo;
    btAddField: TButton;
    btDelField: TButton;
    Panel1: TPanel;
    edField: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    edValue: TEdit;
    btLocate: TButton;
    StatusBar: TStatusBar;
    Label5: TLabel;
    edFilter: TEdit;
    cbFiltered: TCheckBox;
    Splitter: TSplitter;
    btLoad: TButton;
    btSave: TButton;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    btClear: TButton;
    VirtualTable: TVirtualTable;
    DataSource: TDataSource;
    procedure btOpenClick(Sender: TObject);
    procedure btCloseClick(Sender: TObject);
    procedure btAutoFillClick(Sender: TObject);
    procedure DataSourceDataChange(Sender: TObject; Field: TField);
    procedure DataSourceStateChange(Sender: TObject);
    procedure btAddFieldClick(Sender: TObject);
    procedure btDelFieldClick(Sender: TObject);
    procedure btLocateClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure edFilterExit(Sender: TObject);
    procedure cbFilteredClick(Sender: TObject);
    procedure btLoadClick(Sender: TObject);
    procedure btSaveClick(Sender: TObject);
    procedure btClearClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmMain: TfmMain;

implementation

{$R *.dfm}

procedure TfmMain.btOpenClick(Sender: TObject);
begin
  VirtualTable.Open;
  edField.Text:= VirtualTable.Fields[0].FieldName;
end;

procedure TfmMain.btCloseClick(Sender: TObject);
begin
  VirtualTable.Close;
end;

procedure TfmMain.btAutoFillClick(Sender: TObject);
var
  i:integer;
  Field:TField;
begin
  Field:= VirtualTable.FindField('STRING1');
  for i:= 1 to 100 do
    with VirtualTable do begin
      Append;
      FieldByName('NUMBER').AsInteger:= i;
      FieldByName('STRING').AsString:= 'Use Data Access Components from Devart !!! (' + IntToStr(i) + ')';
      FieldByName('DATE').AsDateTime:= Date;
      FieldByName('MEMO').AsString:= 'Memo value (' + IntToStr(i) + ')';

      if Field <> nil then
        FieldByName('STRING1').AsString:= 'TVirtualTable';

      Post;
    end;
end;

procedure TfmMain.DataSourceStateChange(Sender: TObject);
begin
  StatusBar.Panels[0].Text:= 'RecordCount:' + IntToStr(VirtualTable.RecordCount);
  StatusBar.Panels[1].Text:= 'RecordNo:' + IntToStr(VirtualTable.RecNo);
end;

procedure TfmMain.DataSourceDataChange(Sender: TObject; Field: TField);
begin
  DataSourceStateChange(nil);
end;

procedure TfmMain.btAddFieldClick(Sender: TObject);
begin
  VirtualTable.AddField('STRING1', ftString, 30);
end;

procedure TfmMain.btDelFieldClick(Sender: TObject);
begin
  VirtualTable.DeleteField('STRING1');
end;

procedure TfmMain.btLocateClick(Sender: TObject);
begin
  VirtualTable.Locate(edField.Text, Variant(edValue.Text), []);
end;

procedure TfmMain.FormShow(Sender: TObject);
begin
  edFilter.Text:= VirtualTable.Filter;
  cbFiltered.Checked:= VirtualTable.Filtered;
end;

procedure TfmMain.edFilterExit(Sender: TObject);
begin
  VirtualTable.Filter:= edFilter.Text;
end;

procedure TfmMain.cbFilteredClick(Sender: TObject);
begin
  VirtualTable.Filtered:= cbFiltered.Checked;
end;

procedure TfmMain.btLoadClick(Sender: TObject);
begin
  if OpenDialog.Execute then
    VirtualTable.LoadFromFile(OpenDialog.FileName);
end;

procedure TfmMain.btSaveClick(Sender: TObject);
begin
  if SaveDialog.Execute then
    VirtualTable.SaveToFile(SaveDialog.FileName);
end;

procedure TfmMain.btClearClick(Sender: TObject);
begin
  VirtualTable.Clear;
end;

end.
