
//////////////////////////////////////////////////
//  Virtual Data Access Components
//  Copyright  2008-2025 Devart. All right reserved.
//////////////////////////////////////////////////

{$I Dac.inc}
{$I VirtualQuery.inc}
unit VirtualQueryReg;

interface

uses
  VirtualQuery;

procedure Register;

implementation

{$IFNDEF FPC}
  {$IFDEF VER28P}
    {$R VirtualDesign28p.res}
  {$ELSE}
    {$IFDEF VER9}
      {$R VirtualDesign9.res}
    {$ELSE}
      {$R VirtualDesign.res}
    {$ENDIF}
    {$IFDEF VER10P}
      {$R VirtualDesign10p.res}
    {$ENDIF}
  {$ENDIF}
{$ENDIF}

uses
  Classes,
{$IFNDEF FPC}
{$IFDEF VER9P}
  Windows,
{$ENDIF}
{$ENDIF}
{$IFDEF FPC}
  LResources
{$ELSE}
  DacReg
{$ENDIF}
  ;

{$I VirtualDacVer.inc}

procedure Register;
begin
{$IFNDEF FPC}
{$IFNDEF UNIDACPRO}
{$IFDEF VER9P}
  RegisterSplashScreen('Devart Virtual Data Access Components',
                       VirtualDacVersion,
                       LoadBitmap(HInstance, {$IFDEF VER9}'SPLASHGR'{$ENDIF}
                                             {$IFDEF VER10}'SPLASHBL'{$ENDIF}
                                             {$IFDEF VER11}'SPLASHWH'{$ENDIF}
                                             {$IFDEF VER12}'SPLASHWH'{$ENDIF}
                                             {$IFDEF VER14P}'SPLASHBL'{$ENDIF}),
                     {$IFDEF TRIAL}
                       true, 'Trial'
                     {$ELSE} //ORIGINAL
                       false, 'Licensed'
                     {$ENDIF}
                      );

  RegisterAboutBox('Devart Virtual Data Access Components',
                   VirtualDacVersion,
                   'http://www.devart.com/virtualdac/',
                   'Devart Virtual Data Access Components' + #13#10 +
                   'Copyright 1998 - 2025 Devart. All rights reserved.' + #13#10 +
                   'Web: www.devart.com/virtualdac/' + #13#10 +
                   'Support: www.devart.com/virtualdac/support.html',
                   LoadBitmap(HInstance, 'ABOUT'),
                 {$IFDEF TRIAL}
                   true, 'Trial'
                 {$ELSE} //ORIGINAL
                   false, 'Licensed'
                 {$ENDIF}
                   , {$IFDEF PRO}'Standard edition'{$ELSE}'Express edition'{$ENDIF});
{$ENDIF}
{$ENDIF}
{$ENDIF}

  RegisterComponents('Data Access', [TVirtualQuery]);
end;

{$IFDEF FPC}
initialization
  {$I VirtualDesign.lrs}
{$ENDIF}

end.
